package gov.va.med.mhv.usermgmt.util.mvi;

import gov.va.med.mhv.mvi.xsd.AD;
import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CE;
import gov.va.med.mhv.mvi.xsd.COCTMT090003UV01AssignedEntity;
import gov.va.med.mhv.mvi.xsd.COCTMT090003UV01Organization;
import gov.va.med.mhv.mvi.xsd.COCTMT100002UV01Organization;
import gov.va.med.mhv.mvi.xsd.COCTMT100003UV03ContactParty;
import gov.va.med.mhv.mvi.xsd.COCTMT100003UV03Organization;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EN;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.MFMIMT700701UV01Custodian;
import gov.va.med.mhv.mvi.xsd.ON;
import gov.va.med.mhv.mvi.xsd.PN;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02MFMIMT700701UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02MFMIMT700701UV01RegistrationEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02MFMIMT700701UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02MFMIMT700701UV01Subject2;
import gov.va.med.mhv.mvi.xsd.PRPAMT201302UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201302UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201302UV02PatientPatientPerson;
import gov.va.med.mhv.mvi.xsd.ParticipationTargetSubject;
import gov.va.med.mhv.mvi.xsd.RoleClassContact;
import gov.va.med.mhv.mvi.xsd.TEL;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02Document.PRPAIN201302UV02;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;

public class CreateMVIUnCorrelationRequest {
	
	
	
	
	private static final Log LOG = LogFactory.getLog(CreateMVIAuthenticationRequest.class);
	/**
	 * @param userProfile
	 * @param ICN
	 * @return
	 */
	public static String createUnCorrelationXMLRequest(UserProfile userProfile, Patient patient) {
		// Configuration Properties
		MviProperties properties = MviProperties.getInstance();
		
		PRPAIN201302UV02Document root1302Doc = 

		PRPAIN201302UV02Document.Factory.newInstance();
		PRPAIN201302UV02 root1302Req = root1302Doc.addNewPRPAIN201302UV02();
		root1302Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);
		
		/*
			<id extension="MCID-12345" root="2.16.840.1.113883.3.933" />
		    <creationTime value="20070806091603" />
		    <interactionId extension="PRPA_IN201302UV02" root="2.16.840.1.113883.1.6" />
		    <processingCode code="T" />
		    <processingModeCode code="I" />
		    <acceptAckCode code="AL" />
		*/
		II rootId = root1302Req.addNewId();
		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();
		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue) );
		rootId.setRoot(properties.getMviRootId());
		root1302Req.setId(rootId);
		
		TS creationTime = root1302Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());
		
		II interacionId = root1302Req.addNewInteractionId();
		interacionId.setExtension(MviConstants.MVI_INTERACTION_UPGRADE_TYPE);
		interacionId.setRoot(properties.getMviInteractionId());
		
		CS processingCode = root1302Req.addNewProcessingCode();
		if(properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		CS processingModeCode = root1302Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		
		CS acceptAckCode = root1302Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
			<receiver typeCode="RCV">
        		<device classCode="DEV" determinerCode="INSTANCE">
            		<id root="2.16.840.1.113883.4.349" />
        		</device>
    		</receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1302Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II deviceId = device.addNewId();
		deviceId.setRoot(properties.getVaOidValue());
		//TEL deviceTelecom = device.addNewTelecom();
		//deviceTelecom.setValue("https://example.org/PatientFeed");
		
		/*
        <sender typeCode="SND">
        	<device classCode="DEV" determinerCode="INSTANCE">
            	<id extension="200MH" root="2.16.840.1.113883.3.933" />
        	</device>
    	</sender>

		*/
		MCCIMT000100UV01Sender sender = root1302Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());
	
		//PRPAIN201302UV02MFMIMT700701UV01ControlActProcess
		/*
	    <controlActProcess classCode="CACT" moodCode="EVN">
        <subject typeCode="SUBJ">
            <registrationEvent classCode="REG" moodCode="EVN">
                <id nullFlavor="NA" />
                <statusCode code="active" />
        */
		PRPAIN201302UV02MFMIMT700701UV01ControlActProcess controlActProcess = 
			root1302Req.addNewControlActProcess(); 
		root1302Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		
		PRPAIN201302UV02MFMIMT700701UV01Subject1 subject = 
			controlActProcess.addNewSubject();
		subject.setTypeCode(MviConstants.MVI_SUBJECT_TYPE_CODE);
		
		PRPAIN201302UV02MFMIMT700701UV01RegistrationEvent registrationEvent = 
			subject.addNewRegistrationEvent();
		registrationEvent.setClassCode("REG");
		registrationEvent.setMoodCode("EVN");
		II regId = registrationEvent.addNewId();
		regId.setNullFlavor("NA");
		
		CS regStatusCode = registrationEvent.addNewStatusCode();
		regStatusCode.setCode(MviConstants.MVI_ACTIVE_STATUS_CODE);
		/*
        <subject1 typeCode="SBJ">
        <patient classCode="PAT">
        */
		PRPAIN201302UV02MFMIMT700701UV01Subject2 subject1 = 
			registrationEvent.addNewSubject1();
		subject1.setTypeCode(ParticipationTargetSubject.SBJ);
		PRPAMT201302UV02Patient pat = subject1.addNewPatient();
		pat.setClassCode(MviConstants.MVI_PATIENT_CLASS_CODE);
		
		/*
        <id extension="1119970580V776365^NI" root="2.16.840.1.113883.4.349" />
        <statusCode code="active" />
        <confidentialityCode code="ROI^1"/> 
        */
		II patientId = pat.addNewId();
		//patientId.setExtension("1008521868V885186");
		String patientIdExtension = patient.getIcn()+MviConstants.CARET_SYMBOL
			+properties.getMviNationalIdentifier();
		patientId.setExtension(patientIdExtension);
		patientId.setRoot(properties.getVaOidValue());
		CS patientStatusCode = pat.addNewStatusCode();
		patientStatusCode.setCode(MviConstants.MVI_ACTIVE_STATUS_CODE);
				
		/*
        <patientPerson>
            <name use="L">
                <given>James</given>
                <given>Middle Name</given>
                <family>Dean</family>
            </name>
		 */
		PRPAMT201302UV02PatientPatientPerson patientPerson = pat.addNewPatientPerson();
		PN personName = patientPerson.addNewName();
		List list = new ArrayList(); 
		list.add("L");
		personName.setUse(list);
		String givenName = userProfile.getFirstName(); 
		String middleName = userProfile.getMiddleName(); 
		if(middleName != null) {
			String[] givenNameArray = new String[] {givenName, middleName};
			personName.setGivenArray(givenNameArray);
		} else {
			String[] givenNameArray = new String[] {givenName};
			personName.setGivenArray(givenNameArray);
		}
		
		String familyName = userProfile.getLastName(); 
		String[] familyNameArray = new String[] {familyName};
		personName.setFamilyArray(familyNameArray);
		/*
            <telecom use="HP" value="3995552345" />
            <administrativeGenderCode code="M" />
		*/
		CE genderCode = patientPerson.addNewAdministrativeGenderCode();
		if(userProfile.getGender().getName().equalsIgnoreCase(GenderEnumeration.MALE))
			genderCode.setCode(MviConstants.MVI_MALE_GENDER_CODE);
		else if(userProfile.getGender().getName().equalsIgnoreCase(GenderEnumeration.FEMALE))
			genderCode.setCode(MviConstants.MVI_FEMALE_GENDER_CODE);
		/*
            <birthTime value="19570323" />
		 */
		TS birthTime = patientPerson.addNewBirthTime();
		SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
		StringBuilder nowYYYYMMDD = new StringBuilder( dateformatYYYYMMDD.format( 
				userProfile.getBirthDate() ) );
		birthTime.setValue(nowYYYYMMDD.toString());
		/*
		<asOtherIDs classCode="PAT">
        <id root="2.16.840.1.113883.4.349" extension="100000939^PI^523^USVHA"/>
        <statusCode code="2"/>
        <scopingOrganization classCode="ORG" determinerCode="INSTANCE">
            <id root="2.16.840.1.113883.4.349"/>
        </scopingOrganization>
        */
		PRPAMT201302UV02OtherIDs asOtherIds1 = PRPAMT201302UV02OtherIDs.Factory.newInstance();
		asOtherIds1.setClassCode(MviConstants.MVI_PATIENT_CLASS_CODE);
		II asOtherIdsId1 = asOtherIds1.addNewId();
		asOtherIdsId1.setRoot(properties.getVaOidValue());
		//asOtherIdsId1.setExtension("12345^PI^200MH^USVHA");
		String identifierExtension =MviConstants.CARET_SYMBOL+properties.getMviPatientIdentifier()+MviConstants.CARET_SYMBOL
			+properties.getMviReceivingFacilityId()+MviConstants.CARET_SYMBOL
			+properties.getMviFacilityAssignAuthority();
		String dfn = userProfile.getId().toString();
		String identfierExtensionFinal = dfn.concat(identifierExtension);
		asOtherIdsId1.setExtension(identfierExtensionFinal);
		
		CS loaStatusCode = asOtherIds1.addNewStatusCode();

		loaStatusCode.setCode("UNLINK");
	
		COCTMT100002UV01Organization scopingOrg = asOtherIds1.addNewScopingOrganization();
		scopingOrg.setClassCode("ORG");
		scopingOrg.setDeterminerCode("INSTANCE");
		II scopingOrgId1 = scopingOrg.addNewId();
		scopingOrgId1.setRoot(properties.getVaOidValue());
		
		/*
		//This is the old one that is no longer used.
        <asOtherIDs classCode="personLOA">
            <id root="2.16.840.1.113883.4.349" extension="1"/>
            <scopingOrganization classCode="ORG" determinerCode="INSTANCE">
                <id root="1.2.840.114350.1.13.99997.2.3412"/>
            </scopingOrganization>
        </asOtherIDs>
        //MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Updated the LOA 

message according to MVI team -->
		<asOtherIDs classCode="PAT">
			<id root="2.16.840.1.113883.4.349" extension="1234567890^PI^200MH^USVHA" 

/>
			<statusCode code="2" />
			<scopingOrganization classCode="ORG" determinerCode="INSTANCE">
				<id root="2.16.840.1.113883.4.349" />
			</scopingOrganization>
		</asOtherIDs>
		 */
//		PRPAMT201302UV02OtherIDs asOtherIds2 = 

//PRPAMT201302UV02OtherIDs.Factory.newInstance();
//		asOtherIds2.setClassCode("personLOA");
//		II asOtherIdsId2 = asOtherIds2.addNewId();
//		asOtherIdsId2.setRoot(properties.getVaOidValue());
//		
//		identifierExtension =MviConstants.CARET_SYMBOL

//+properties.getMviPatientIdentifier()+MviConstants.CARET_SYMBOL
//
//+properties.getMviReceivingFacilityId()+MviConstants.CARET_SYMBOL
//
//+properties.getMviFacilityAssignAuthority();
//		dfn = userProfile.getId().toString();
//		identfierExtensionFinal = dfn.concat(identifierExtension);
//		asOtherIdsId2.setExtension(identfierExtensionFinal);
//		
//		CS loaStatusCode = asOtherIds2.addNewStatusCode();
//
//		if(authenticate)
//			//asOtherIdsId2.setExtension("2");
//			loaStatusCode.setCode("2");
//		else
//			//asOtherIdsId2.setExtension("1");
//			loaStatusCode.setCode("1");
//		
//		COCTMT100002UV01Organization scopingOrg2 = asOtherIds2.addNewScopingOrganization

//();
//		scopingOrg2.setClassCode("ORG");
//		scopingOrg2.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
//		II scopingOrgId2 = scopingOrg2.addNewId();
//		scopingOrgId2.setRoot(properties.getVaOidValue());
		
		/*
        <asOtherIDs classCode="SSN">
                <id extension="999-99-4452" root="2.16.840.1.113883.4.1" />
                <scopingOrganization classCode="ORG" determinerCode="INSTANCE">
                    <id root="2.16.840.1.113883.4.1" />
                </scopingOrganization>
            </asOtherIDs>
        </patientPerson>
        */
		PRPAMT201302UV02OtherIDs asOtherIds3 = PRPAMT201302UV02OtherIDs.Factory.newInstance();
		asOtherIds3.setClassCode(MviConstants.MVI_SSN_CLASS_CODE);
		II asOtherIdsId3 = asOtherIds3.addNewId();
		asOtherIdsId3.setRoot(properties.getMviUsssaIdentifierId());
		String formattedSSN = userProfile.getSsn().replaceAll("[\\s\\-()]", "");
		asOtherIdsId3.setExtension(formattedSSN);
		COCTMT100002UV01Organization scopingOrg3 = asOtherIds3.addNewScopingOrganization();
		scopingOrg3.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		scopingOrg3.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II scopingOrgId3 = scopingOrg3.addNewId();
		scopingOrgId3.setRoot(properties.getVaOidValue());
		
		PRPAMT201302UV02OtherIDs[] OtherIDsArray = new PRPAMT201302UV02OtherIDs[] {asOtherIds1, asOtherIds3 };
		patientPerson.setAsOtherIDsArray(OtherIDsArray);
		
        //<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
        <providerOrganization classCode="ORG" determinerCode="INSTANCE">
            <id root="1.2.840.114350.1.13.99998.8734" />
            <name>Good Health Clinic</name>
            <contactParty classCode="CON">
            </contactParty>
        </providerOrganization>

		*/
		
		COCTMT100003UV03Organization providerOrg = pat.addNewProviderOrganization();
		providerOrg.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		providerOrg.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II providerOrgId = providerOrg.addNewId();
		providerOrgId.setRoot(properties.getVaOidValue());
		ON instance1 = ON.Factory.newInstance();
		//onlist.add("A");
		instance1.addDelimiter("MyHealtheVet");
		ON[] providerOrgOn = new ON[] {instance1};
		providerOrg.setNameArray(providerOrgOn);
		
		COCTMT100003UV03ContactParty contactParty = providerOrg.addNewContactParty();
		contactParty.setClassCode(RoleClassContact.CON);
		// ENDED HERE
		
		//<!-- Not currently used by IDM. Added to support Hl7v3 XSD validation -->
		/*
			<custodian typeCode="CST">
                    <assignedEntity classCode="ASSIGNED">
                        <id root="1.2.840.114350.1.13.99998.8734" />
                        <assignedOrganization classCode="ORG" determinerCode="INSTANCE">
                            <name>Good Health Clinic</name>
                        </assignedOrganization>
                    </assignedEntity>
            </custodian>
		*/
		
		MFMIMT700701UV01Custodian custodian = registrationEvent.addNewCustodian();
		custodian.setTypeCode("CST");
		COCTMT090003UV01AssignedEntity assignedEntity = custodian.addNewAssignedEntity();
		assignedEntity.setClassCode("ASSIGNED");
		II assignedEntityId = assignedEntity.addNewId();
		assignedEntityId.setRoot(properties.getVaOidValue());
		COCTMT090003UV01Organization assignedOrganization = assignedEntity.addNewAssignedOrganization();
		assignedOrganization.setClassCode(MviConstants.MVI_SCOPE_ORG_CLASS_CODE);
		assignedOrganization.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		EN assignedOrgName = assignedOrganization.addNewName();
		//assignedOrganization.setNameArray(aen);
		//assignedOrganization.setNameArray(aen)
		//assignedOrgName.setset("TESTING");
		//assignedOrganization.setNameArray();
		/*
		XmlObject temp = XmlObject.Factory.newInstance();
		assignedOrgName.set(temp);
		*/
		//EN assignedOrgName = EN.Factory.newInstance();
		assignedOrgName.addDelimiter("MyHealtheVet");
		//Ended Here
		
		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1302Doc.xmlText(options));
        
        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);
        
        boolean valid =root1302Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1302 Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
        //CR1964 - Made sure that the code doesn't get into infinite loop.
          if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  				LOG.debug(itr.next().toString());
	          }
    	  }
        }  
		
        return root1302Doc.xmlText();
		
	}
}
